<?php
/**
 * Whole Prices Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Wholesale_prices extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Wholesale_prices_model');
		$this->load->model('Items_model');
	}

 	public function edit($id)
	{
		$title       = "Harga Grosir";
		$where       = array('item_id' => $id);
		$header_data = $this->Items_model->get_data($where)->row_array();
		
		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		
		$this->twiggy_display('adm/wholesale_prices/edit', $data);
	}

	public function get_data_detail()
	{	
		$id = $this->input->post("id");
		$where       = array('a.item_id' => $id);

		$data = [];
		$get_data = $this->Wholesale_prices_model->get_data($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{

				$data[] = array(
					'no'     => $no,
					'id'     => $get_row->item_id,
					'min_order'   => number_format($get_row->minimum_order),
					'max_order'   => number_format($get_row->maximum_order),
					'price'  => number_format($get_row->price),
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function save()
	{	
		$id       = $this->input->post('id');
		$vuedata  = $this->input->post('vuedata');
		
		$where    = array('a.item_id' => $id);
		$get_data = $this->Wholesale_prices_model->get_data($where)->result();
		$detail_data = [];

		if($vuedata == null){
			$delete_detail = $this->Wholesale_prices_model->delete($id);
			if($delete_detail)
			{
				$msg    = "Berhasil menyimpan data";
				$status = "success";
			}
			else
			{
				$msg    = "Gagal menyimpan data";
				$status = "error";	
			}
		}else{
			if(count($get_data) > 0){
				$delete_detail = $this->Wholesale_prices_model->delete($id);
			}

			foreach($vuedata as $row)
			{
				$detail_data[] = [
					'item_id'      => $id,
					'minimum_order'  => $row['min_order'],
					'maximum_order'  => $row['max_order'],
					'price'        => trims($row['price']),
					'is_active'    => '1',
				];
			}

			$save_detail = $this->Wholesale_prices_model->save($detail_data, true);
			
			if($save_detail)
			{
				$msg    = "Berhasil menyimpan data";
				$status = "success";
			}
			else
			{
				$msg    = "Gagal menyimpan data";
				$status = "error";	
			}
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $id
		];
		output_json($response);
	}

}

?>
